/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item.food;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.api.AntiFeedingFoodItem;
import com.renyigesai.immortalers_delight.api.PlateBaseBlock;
import com.renyigesai.immortalers_delight.block.StackedFoodBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.item.PowerfulAbleFoodItem;
import com.renyigesai.immortalers_delight.potion.immortaleffects.DeathlessEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ShieldLikeFoodItem
extends PowerfulAbleFoodItem
implements AntiFeedingFoodItem {
    public final int type;
    @javax.annotation.Nullable
    private final FoodProperties aheadFoodProperties;
    @javax.annotation.Nullable
    private final FoodProperties poweredAheadFoodProperties;
    @javax.annotation.Nullable
    private FoodProperties noEffectFoodProperties = null;

    public ShieldLikeFoodItem(Item.Properties properties, @Nullable FoodProperties powerFoodProperties, @Nullable FoodProperties aheadFoodProperties, @Nullable FoodProperties poweredAheadFoodProperties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, int type) {
        super(properties, powerFoodProperties, true, true);
        this.aheadFoodProperties = aheadFoodProperties;
        this.poweredAheadFoodProperties = poweredAheadFoodProperties;
        this.type = type;
    }

    public ShieldLikeFoodItem(Item.Properties properties, @Nullable FoodProperties powerFoodProperties, @Nullable FoodProperties aheadFoodProperties, @Nullable FoodProperties poweredAheadFoodProperties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, boolean isFoil, int type) {
        super(properties, powerFoodProperties, true, true, isFoil);
        this.aheadFoodProperties = aheadFoodProperties;
        this.poweredAheadFoodProperties = poweredAheadFoodProperties;
        this.type = type;
    }

    public BlockState getPlaceState(Level level, BlockPos blockpos) {
        Block block = Blocks.f_50016_;
        Block block1 = (Block)ImmortalersDelightBlocks.EVOLUTCORN_HARD_CANDY.get();
        Block block2 = (Block)ImmortalersDelightBlocks.KU_MESH_NON.get();
        if (this.type == 1) {
            block = block1;
        }
        if (this.type == 2) {
            block = block2;
        }
        if (block instanceof StackedFoodBlock) {
            StackedFoodBlock stackedFoodBlock = (StackedFoodBlock)block;
            return (BlockState)stackedFoodBlock.m_49966_().m_61124_((Property)StackedFoodBlock.BITES, (Comparable)Integer.valueOf(stackedFoodBlock.getMaxBites() - stackedFoodBlock.getPileBitesPerItem()));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        PlateBaseBlock plateBaseBlock;
        BlockPos blockpos;
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = pContext.m_8083_());
        Block block = blockstate.m_60734_();
        if (block instanceof PlateBaseBlock && (plateBaseBlock = (PlateBaseBlock)block).isEmptyPlate(blockstate)) {
            level.m_5594_(player, blockpos, SoundEvents.f_12633_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            BlockState blockstate1 = this.getPlaceState(level, blockpos);
            level.m_7731_(blockpos, blockstate1, 11);
            level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
            ItemStack itemstack = pContext.m_43722_();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 300;
    }

    @Nullable
    public FoodProperties getAheadFoodProperties() {
        return DifficultyModeUtil.isPowerBattleMode() ? this.poweredAheadFoodProperties : this.aheadFoodProperties;
    }

    private void addAheadFoodEffect(ItemStack stack, Level level, LivingEntity livingEntity) {
        ShieldLikeFoodItem shieldLikeFoodItem;
        Item item = stack.m_41720_();
        if (item instanceof ShieldLikeFoodItem && (shieldLikeFoodItem = (ShieldLikeFoodItem)item).getAheadFoodProperties() != null) {
            for (Pair pair : shieldLikeFoodItem.getAheadFoodProperties().m_38749_()) {
                if (level.m_5776_() || pair.getFirst() == null) continue;
                livingEntity.m_7292_((MobEffectInstance)pair.getFirst());
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.immortalers_delight.can_place_on_plate").m_130940_(ChatFormatting.GRAY));
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
            if (this.type == 1) {
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.type == 2) {
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.GRAY));
            }
            this.addUsedEffectTooltip(stack, tooltip, 1.0f);
        }
    }

    @Override
    public FoodProperties getWholeFoodStats(ItemStack itemIn) {
        return DifficultyModeUtil.isPowerBattleMode() ? this.poweredFoodProperties : super.m_41473_();
    }

    @Override
    public FoodProperties m_41473_() {
        if (this.noEffectFoodProperties != null) {
            return this.noEffectFoodProperties;
        }
        if (super.m_41473_() != null) {
            this.noEffectFoodProperties = this.notEffectFood(super.m_41473_());
            return this.noEffectFoodProperties;
        }
        return super.m_41473_();
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration >= 0 && !pLivingEntity.m_9236_().m_5776_() && pStack.m_41720_() instanceof ShieldLikeFoodItem && pRemainingUseDuration >= 14 && (this.m_8105_(pStack) - pRemainingUseDuration + 1) % 14 == 1) {
            this.addAheadFoodEffect(pStack, pLivingEntity.m_9236_(), pLivingEntity);
        }
        if (pRemainingUseDuration == 1) {
            this.addEatEffect(pStack, pLevel, pLivingEntity);
            if (this.type == 1) {
                DeathlessEffect.applyImmortalEffect(pLivingEntity, 40, 0);
            }
        }
    }
}

